/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.common.entity.AirdropEntity;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class FlareEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private int startHeight;
    private int timeWaiting;
    private boolean playerThrown;

    public FlareEntity(EntityType<? extends FlareEntity> type, World world) {
        super(type, world);
        this.func_82142_c(true);
    }

    public FlareEntity(World world, PlayerEntity owner) {
        this((EntityType<? extends FlareEntity>)((EntityType)ModEntities.FLARE.get()), world);
        this.func_70107_b(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
        this.startHeight = (int)this.func_226278_cu_();
    }

    public void setThrownByPlayer(PlayerEntity player) {
        this.playerThrown = true;
        float power = 1.5f;
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)player.func_70047_e(), this.func_226281_cx_());
        Vector3d look = Vector3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z).func_186678_a((double)power);
        this.func_213293_j(look.field_72450_a, look.field_72448_b, look.field_72449_c);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.startHeight);
        buffer.writeInt(this.timeWaiting);
        buffer.writeBoolean(this.playerThrown);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.startHeight = buffer.readInt();
        this.timeWaiting = buffer.readInt();
        this.playerThrown = buffer.readBoolean();
    }

    protected void func_70088_a() {
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("startHeight", this.startHeight);
        nbt.func_74768_a("timeWaiting", this.timeWaiting);
        nbt.func_74757_a("byPlayer", this.playerThrown);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.startHeight = nbt.func_74762_e("startHeight");
        this.timeWaiting = nbt.func_74762_e("timeWaiting");
        this.playerThrown = nbt.func_74767_n("byPlayer");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, true, this.func_226277_ct_(), this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 0.0, 0.015, 0.0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_() + 0.2, 0.0, 0.012, 0.0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, true, this.func_226277_ct_(), this.func_226278_cu_() + 0.2, this.func_226281_cx_(), 0.0, 0.01, 0.0);
        }
        if (this.field_70173_aa > 1000) {
            this.playerThrown = true;
        }
        if (this.playerThrown) {
            if (++this.timeWaiting >= 400) {
                this.summonAirdrop(100, 0);
            }
            Vector3d delta = this.func_213322_ci();
            double drag = this.field_70122_E ? 0.8 : 0.99;
            Vector3d nextTickPhysics = delta.func_216372_d(drag, 1.0, drag).func_72441_c(0.0, -0.05, 0.0);
            this.func_213317_d(nextTickPhysics);
        } else {
            boolean reachedHeight;
            Vector3d motion = this.func_213322_ci();
            boolean bl = reachedHeight = this.func_226278_cu_() >= (double)(this.startHeight + 125);
            if (!reachedHeight) {
                this.func_213293_j(motion.field_72450_a, 0.55, motion.field_72449_c);
            } else {
                this.func_213293_j(0.0, 0.0, 0.0);
                if (++this.timeWaiting >= 100) {
                    this.summonAirdrop(-10, 130);
                }
            }
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public void summonAirdrop(int heightDiff, int soundDiff) {
        if (!this.field_70170_p.field_72995_K) {
            AirdropEntity entity = new AirdropEntity(this.field_70170_p);
            entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)heightDiff, this.func_226281_cx_());
            this.field_70170_p.func_217376_c((Entity)entity);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() - (double)soundDiff, this.func_226281_cx_(), ModSounds.PLANE_FLY_BY, SoundCategory.MASTER, 7.0f, 1.0f);
            this.func_70106_y();
        }
    }

    public boolean func_70112_a(double p_70112_1_) {
        return true;
    }
}

